package ga.core.individual;

import ga.core.validation.GAContext;

/**
 * This factory creates new individuals by cloning a template.
 * 
 * @param <T>
 *          The generic type of individuals.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public class TemplateIndividualFactory<T extends IIndividual<T>> implements
    IIndividualFactory<T> {

  private final T template;

  /**
   * Creates a new factory with the template.
   * 
   * @param template
   *          The individual template that will be cloned.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public TemplateIndividualFactory(final T template) {
    this.template = template;
  }

  @Override
  public T newIndividual(final GAContext context) {
    final T individual = template.clone();
    individual.setContext(context);
    individual.initRandomly();
    return individual;
  }
}
